Include([[Data/levels/include/level_utils.lua]])

Level =
{
	MapSkinFilename = [[hatchery.lua]],
	MapGenScript = LevelUtils.MapGenFromSVG([[mission8.svg]]),
	Parameters =
	{
		MarineCount 		= 5,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 20.0,
		PointGainPerCapture = 7,
		StartBuildPoints    = 20
	},
	Rules = 
	{
		AutoCapture 	= false,		--Destroying hives automatically counts as a capture
		NoPushback		= false,		--Can the player's points be captured?
		NoTowerRespawn  = false,        --Can the hive towers respawn?
		WeakenHiveOnCap = true,         --Do captures halve defensive strength?
		DisableLockdown = true,         --Turn off emergency help is player is behind
		NoAdvance       = false,        --Do not allow player to capture points
		HiveCtrAttack   = false,        --Send alien spawn to undefended alien hives
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 0,
		Default = [[disabled]],
		Active =
		{
		},
		Queue =
		{
		    [[ZU_ZOMBIE_MINES]],
		    [[ZU_HIVE_SPIKES]],
		    [[ZU_WALK_SPEED]],
		    [[ZU_DEF_BRUTES]],
		    [[ZU_SPAWNER_SPECIAL]],
		    [[ZU_RUST]],
		    [[ZU_NECRONODE]],
		    [[ZU_REGENERATION]],
		    [[ZU_SPAWN_BRUTES]], 
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		--Default = [[inactive]],
		--FreeUpgradesDefault = [[active]],
		Active =
		{
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	},
	
	OnDebugCall = function (mousePos)
        
	end
}


------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)		

        ScriptMgr:DoDelayedCall(45000,
        function()
            SpawnNPCWave()
            CreateGeneralsTeam(true)
            
            return true
        end)
        SpawnNPCWave()
        
        CreateGeneralsTeam(false)
        
        GameWorld:CreateTrainingArrow("doctor",     "PNT_PORTRAIT_SCOUT")
        
        CreateBunkerWarning("humanBunker1")
        CreateBunkerWarning("humanBunker2")
        CreateBunkerWarning("humanBunker3")
        
        DestroyTrigger:Enable() 
        GeneralGoal:Enable()
        LossCondition:Enable()
        CaptureAllGoal:Enable()
        
        LevelUtils.ShowTimedDialogue("When I bring your body to the Harvester, I can finally rest\n\nCome closer... I tire of the hunt", "GeneralInfested", 15000)
        
		self:Disable()
	end)
LevelInit:Enable()
            
function CountAliveEntities(p_idList)

    aliveCount = 0
    for i=1, #p_idList do
        local entId = p_idList[i]
        local ent = GameWorld:GetEntityById(entId)
        
        if ent then
            aliveCount = aliveCount + 1
        end
    end

    return aliveCount
end

function PickAliveEntity(p_idList)

    for i=1, #p_idList do
        local entId = p_idList[i]
        local ent = GameWorld:GetEntityById(entId)
        
        if ent then
            return p_idList[i]
        end
    end

    return nil
end

function CreateBunkerWarning(p_entId)

    local entity = GameWorld:GetEntityById(p_entId)
    if entity == nil then
        return
    end

    LevelUtils.CreateEntityHPMonitor(entity:GetHandle(), {0.75, 0.50, 0.25},
        function (p_hpFract)
                    
            local phrases = {   "One of the barracks is about to be destroyed\n\nHurry back and save it!",
                                "A barrack is under attack!\n\nYou need to save it, commander.",
                                "They are attacking our base!"}
            local phraseIndex = GetRandomRangeInt(1, #phrases)
            local text_hdl =  GameWorld:ShowText(phrases[phraseIndex], "Scout") 
            
            GameWorld:CreateTrainingArrow(p_entId)
            ScriptMgr:DoDelayedCall(7000,
                function ()
                    text_hdl:ClearText()
                    GameWorld:RemoveTrainingArrow(p_entId)
                end) 

        end,
        true)
        
end
          
baseAlienWaveSize = 15
alienWaveSize = baseAlienWaveSize    
function SpawnNPCWave()

    local alienBunkersActive = CountAliveEntities({"alienBunker1", "alienBunker2", "alienBunker3"})
    if alienBunkersActive > 0 then
        local waveSize = math.floor(alienWaveSize / alienBunkersActive) - (3 - alienBunkersActive)*5
        waveSize = math.max(waveSize, 5)
    
        CreateMarineTeam("InfestedMarine", "alienBunker1", {"waypoint1_0", "waypoint1_1", "waypoint1_2", "waypointFinalRight"}, waveSize)
        CreateMarineTeam("InfestedMarine", "alienBunker2", {"waypoint2_0", "waypoint2_1", "waypointFinalRight"}, waveSize)
        CreateMarineTeam("InfestedMarine", "alienBunker3", {"waypoint3_0", "waypoint3_1", "waypointFinalRight"}, waveSize)
    end

    local humanBunkersActive = CountAliveEntities({"humanBunker1", "humanBunker2", "humanBunker3"})
    if humanBunkersActive > 0 then
        local waveSize = math.floor(15 / humanBunkersActive)
    
        CreateMarineTeam("AIMarine", "humanBunker1", {"waypoint1_2", "waypoint1_1", "waypoint1_0", "waypointFinalLeft"}, waveSize)
        CreateMarineTeam("AIMarine", "humanBunker2", {"waypoint2_1", "waypoint2_0", "waypointFinalLeft"}, waveSize)
        CreateMarineTeam("AIMarine", "humanBunker3", {"waypoint3_1", "waypoint3_0", "waypointFinalLeft"}, waveSize)
    end

end

function CreateMarine(p_type, p_spawnEntId, p_offset)

    local startEnt = GameWorld:GetEntityById(p_spawnEntId)
    if startEnt == nil then
        return
    end

    local marine = GameWorld:CreateEntity(p_type, "", startEnt:GetPos() + p_offset)
    
    marine:SetDegeneration(false)
--[[
    local alienWeapons = {  [4] = WeaponType.WT_MEDIC,
                            [6] = WeaponType.WT_FUSIONRIFLE,
                            [7] = WeaponType.WT_FUSIONRIFLE,
                            [8] = WeaponType.WT_MEDIC,
                            [9] = WeaponType.WT_FUSIONRIFLE,
                            [10] = WeaponType.WT_FLAMETHROWER,
                            [11] = WeaponType.WT_SNIPERRIFLE   }
    local preferredWeapon = alienWeapons[#self.teamHandles+1]

    if preferredWeapon ~= nil then
        marine:SetWeaponType(preferredWeapon)
    end

    self:AddTeamMember(marine)
--]]

    return marine
end

function OrderMarineWaypoints(p_marinePtr, p_waypointIdList, p_offset)

    local firstPoint = true
    for i=1, #p_waypointIdList do
        local waypointId = p_waypointIdList[i]
        
        local waypointEnt = GameWorld:GetEntityById(waypointId)
        if waypointEnt ~= nil then
            p_marinePtr:SendCommand(ICommandable.CT_ATTACKMOVE, waypointEnt:GetPos() + p_offset, nil, firstPoint ~= true)
        end
     
        firstPoint = false
    end      
end

function CreateMarineTeam(p_type, p_spawnEntId, p_waypointIdList, p_teamSize)

    local startEnt = GameWorld:GetEntityById(p_spawnEntId)
    if startEnt == nil then
        return
    end

    for i=1, p_teamSize do
        local offsetDelta = vect2f.MakePolar(GetRandomRange(2.0, 3.0), i/p_teamSize*math.pi*2)
        
        local marine = CreateMarine(p_type, p_spawnEntId, offsetDelta)
        
        OrderMarineWaypoints(marine, p_waypointIdList, offsetDelta)
    end   
end


local generalsTeam = {
                        {weapon=WeaponType.WT_MINIGUN,      offset=vect2f(0,0)},
                        
                        {weapon=WeaponType.WT_AUTORIFLE,    offset=vect2f(12.0,0)},
                        {weapon=WeaponType.WT_AUTORIFLE,    offset=vect2f(0,-12.0)},
                        {weapon=WeaponType.WT_AUTORIFLE,    offset=vect2f(8.0,-8.0)},
                        {weapon=WeaponType.WT_AUTORIFLE,    offset=vect2f(8.0,8.0)},
                        {weapon=WeaponType.WT_AUTORIFLE,    offset=vect2f(-8.0,-8.0)},
                        
                        {weapon=WeaponType.WT_FUSIONRIFLE,  offset=vect2f(6.0,0)},
                        {weapon=WeaponType.WT_FUSIONRIFLE,  offset=vect2f(0,-6.0)},
                        {weapon=WeaponType.WT_MEDIC,        offset=vect2f(4.0,-4.0)},
                        {weapon=WeaponType.WT_SNIPERRIFLE,  offset=vect2f(4.0,4.0)},
                        {weapon=WeaponType.WT_SNIPERRIFLE,  offset=vect2f(-4.0,-4.0)},
                        
                        {weapon=WeaponType.WT_FLAMETHROWER, offset=vect2f(16.0,16.0)},
                        {weapon=WeaponType.WT_FLAMETHROWER, offset=vect2f(16.0,-16.0)},
                        {weapon=WeaponType.WT_FLAMETHROWER, offset=vect2f(-16.0,-16.0)},                        
                     }
                     
local generalHandle = nil  

function UpdateGeneralGodMode(p_milliseconds)
  
    local otherTeamMember = nil
    local numberAlive = 0
    for i=1, #generalsTeam do
        local spawnInfo = generalsTeam[i]
    
        if spawnInfo.handle then
            local entity = spawnInfo.handle:GetPtr()
            if entity then
                numberAlive = numberAlive + 1
                if i > 1 and otherTeamMember == nil then
                    otherTeamMember = entity
                end
            end
        end
    end
    
    if generalHandle then
        local general = generalHandle:GetPtr()
        
        if general then
            local alienBunkersActive = CountAliveEntities({"alienBunker1", "alienBunker2", "alienBunker3"})
            general:SetGodMode(numberAlive > 1 or alienBunkersActive > 0)
            
            if otherTeamMember and general:GetHPFraction() < 0.05 then
                general:SetHPFraction(1.0)
                otherTeamMember:DamageKill()
            end
        end
    end   

end
ScriptMgr:SetUpdateCallback(UpdateGeneralGodMode)
     
function CreateGeneralsTeam(p_respawnMode)

    local startEntId = "generalDrop"
    if p_respawnMode then
        startEntId = PickAliveEntity({"alienBunker1", "alienBunker2", "alienBunker3"})
        
        if not startEntId then
            return
        end
    end

    local startEnt = GameWorld:GetEntityById(startEntId)
    if startEnt == nil then
        return
    end

    local protectEntity = nil
    local teamList = {}
    local startIndex = 1
    if p_respawnMode then
        startIndex = 2
    end
    for i=startIndex, #generalsTeam do
        local spawnInfo = generalsTeam[i]
        local offset = spawnInfo.offset
        
        if p_respawnMode then
            offset = vect2f(0,0)
        end
        
        if spawnInfo.handle and not spawnInfo.handle:GetPtr() then
            spawnInfo.handle = nil
        end
        
        if not spawnInfo.handle then
            local marine = GameWorld:CreateEntity("InfestedMarine", "", startEnt:GetPos() + offset)
            marine:SetDegeneration(false)
            
            if spawnInfo.weapon ~= nil then
                marine:SetWeaponType(spawnInfo.weapon)
            end
            
            if generalHandle == nil and i==1 then
                generalHandle = marine:GetHandle()
                marine:MakeHero()
                
                GameWorld:CreateTrainingArrow(marine:GetId(),     "PNT_PORTRAIT_GENERAL_INFESTED")
            else
                marine:CommandProtect(generalHandle:GetPtr(), spawnInfo.offset)        
            end
            
            for j=1, #generalsTeam do 
                local spawnInfo2 = generalsTeam[j]
                if spawnInfo2.handle then
                    local marine2 = spawnInfo2.handle:GetPtr()
                    if marine2 then
                        marine2:AddTeammate(marine)
                        marine:AddTeammate(marine2)
                    end
                end
            end
            
            spawnInfo.handle = marine:GetHandle()
        end
    end

end

ScriptMgr:DoDelayedCall(5000,
    function()
        local startEnt = GameWorld:GetEntityById("generalDrop")
        if startEnt == nil then
            return false
        end
    
        if generalHandle == nil then
            return false
        end
        
        local general = generalHandle:GetPtr()
        if not general then
            return false
        end        
    
        if general:GetIsIdle() and not vect2f.IsDistLess(general:GetPos(), startEnt:GetPos(), 20.0) then
            general:SendCommand(ICommandable.CT_ATTACKMOVE, startEnt:GetPos(), nil, false)
        end
        
        return true
    end)

--[[
ScriptMgr:DoDelayedCall(60000,
    function()
        CreateGeneralsTeam(true)
        
        return true
    end)   
--]]

    
------------------------------------------------------------------------------- Capture Trigger
CaptureTrigger = LevelUtils.MakeGoal(
	function (self)
		self.capture_counter = 0
	end,
	
	{[[NT_CAPTURE_RECORD]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		
		self.capture_counter = self.capture_counter + 1
		
        alienWaveSize = baseAlienWaveSize + self.capture_counter
        
        if self.capture_counter >= 9 then
            GameWorld:SetSpawnRate(10.0)
            GameWorld:SetSpawnRateScalingOn(false)
        end
        
	end)
CaptureTrigger:Enable()

function string.starts(String,Start)
   return string.sub(String,1,string.len(Start))==Start
end

------------------------------------------------------------------------------- Bunker Destroy Trigger
DestroyTrigger = LevelUtils.MakeGoal(
	function (self)
		GameWorld:AddObjective("bunkerObj", "Kill bunkers to weaken general")
		
		self.bunkers_dead = 0
	end,
	
	{[[NT_ENTITY_DESTROYED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		if not string.starts(p_entId, "alienBunker") then
			return
		end
		
		self.bunkers_dead = self.bunkers_dead + 1
		
		if self.bunkers_dead == 1 then
		    LevelUtils.ShowTimedDialogue("I have seen the face of god\n\nCan you say the same?", "GeneralInfested")
        elseif self.bunkers_dead == 2 then
			LevelUtils.ShowTimedDialogue("Ignore that creature's transmissions, commander\n\nIt is just a meat puppet for its master", "Scout")
		elseif self.bunkers_dead == 3 then
		    GameWorld:ChangeObjectiveStatus("bunkerObj", [[complete]])
		    CompleteObjective("bunkerObj")
		    
		    CrateDropScript:Enable()
		end
		
		local crateCount = 3
        for i=1,crateCount do
            local offsetDelta = vect2f.MakePolar(4.0, i/crateCount*math.pi*2)
            GameWorld:CreateEntity("BPCrate", "", p_pos + offsetDelta)            
        end
        
	end,
	
	function (self)
	end) 


------------------------------------------------------------------------------- Kill the General
GeneralGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:AddObjective("generalObj", "Kill the general clone and its team")
	end,
	
	{[[NT_ENTITY_DESTROYED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		if not generalHandle then
			return
		end
		
		local generalEnt = generalHandle:GetPtr()
		if not generalEnt then
		    return
		end
		
		if generalEnt:GetId() ~= p_entId then
		    return
		end
		
		GameWorld:ChangeObjectiveStatus("generalObj", [[complete]])
		CompleteObjective("generalObj")
		
		LevelUtils.ShowTimedDialogue("Damn.\n\nMagnusson was a pompous prick, but even he didn't deserve that.", "Sarge")
		
		self:Disable()
	end,
	
	function (self)
	end) 

------------------------------------------------------------------------------- Lost all points
LossCondition = LevelUtils.MakeGoal(
	function (self)	
	end,
	
	{[[NT_ALL_POINTS_LOST]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[failed]])
	
        GameWorld:ClearText()
        GameWorld:GameOver(false)
		
		objectivesCompleteList = {}
		
		self:Disable()
	end)

------------------------------------------------------------------------------- Victory Condition - Capture All Points (short-circuit)
CaptureAllGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:AddObjective("winObj", "Capture all the enemy points")
	end,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[complete]])
				
		CompleteObjective("winObj")
		
		self:Disable()
	end) 
	
objectivesCompleteList = {}
function CompleteObjective(p_objectiveName)

    objectivesCompleteList[p_objectiveName] = true

    if  objectivesCompleteList["winObj"] and
        objectivesCompleteList["generalObj"] and
        objectivesCompleteList["bunkerObj"] then
        
        GameWorld:ClearText()
        GameWorld:GameOver(true)
    end
        
end

------------------------------------------------------------------------------- Chopper Marine Airdrop
CrateDropScript = LevelUtils.MakeGoal(
	function (self)	
		
		local dropList = {"waypoint1_0", "waypoint2_0", "waypoint3_0"}
		for i=1,#dropList do
            local dropArea = GameWorld:GetEntityById(dropList[i]);
            if dropArea then
                local chopper = GameWorld:SpawnChopper(vect2f(1.0, 0.0), dropArea:GetPos())
                chopper:SetMission(ChopperOrder.CO_DELIVERY, dropArea:GetPos(), dropArea:GetId())
            end
		end
		
		self.dropInfo = {}
		self.dropInfo["waypoint1_0"] = {WeaponType.WT_MEDIC, WeaponType.WT_FUSIONRIFLE, WeaponType.WT_FLAMETHROWER}
		self.dropInfo["waypoint2_0"] = {WeaponType.WT_MEDIC, WeaponType.WT_FLAMETHROWER, WeaponType.WT_MINIGUN}
		self.dropInfo["waypoint3_0"] = {WeaponType.WT_MEDIC, WeaponType.WT_FUSIONRIFLE, WeaponType.WT_FLAMETHROWER}
		
		LevelUtils.ShowTimedDialogue("Bloody hells woman.\nI step away for a few days and here you are killing your commanding officer.\n\nNeed a hand?", "Sarge", 15000)
		
	end,
	
	{[[NT_CHOPPER_DELIVERY]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
		local dropInfo = self.dropInfo[p_other]
		if dropInfo == nil then
		    return
		end
		
		for i=1, #dropInfo do
		    local offsetDelta = vect2f.MakePolar(4.0, i/#dropInfo*math.pi*2)
		    
            local marine = GameWorld:CreateEntity("AIMarine", "", p_pos + offsetDelta)
            marine:SetWeaponType(dropInfo[i])
            
            if dropInfo[i] == WeaponType.WT_MINIGUN then
                marine:MakeHero()
                GameWorld:CreateTrainingArrow(marine:GetId(),   "PNT_PORTRAIT_SARGE") 
            end
            
            marine:SetGodMode(true)
            
        end
		
	end)
		
------------------------------------------------------------------------------- Extra Win Achievement
LevelUtils.MakeGoal(
	function (self)
	end,
	
	{[[NT_GAME_OVER]]},
	function (self, p_type, p_entId, p_pos, p_other)
        if p_other == "win" and CountAliveEntities({"humanBunker1", "humanBunker2", "humanBunker3"}) >= 3 then
		    SteamAchievements:SetAchievement("BEAT_PERIAPSIS_EXTRA_NOLOSS")
		end	
	end):Enable()
